varying vec2 TexCoord0;
uniform sampler2D tex;
uniform vec2 texSize;
uniform float pts;
uniform sampler2D auxTex;
uniform float intensity;

float Hash(float x)
{
	return fract(sin(x * 21.34) * 456.78);
}

vec2 GetDrops(vec2 uv, float t, float speedMultiplier) 
{
	vec2 gridSize = vec2(10.0, 4.0) * intensity + vec2(0.001);        // Grid size
	float sizeOffset = texture2D(auxTex, uv * 0.1).x;                 // Random offset for the size
	float speed = ((Hash(floor(uv * gridSize).x) + 1.0) * 0.5) * 0.2; // Random drop speed 0->0.2
	uv.y -= speed * t * speedMultiplier;                              // Move the grid down in time

	vec2 st = fract(uv * gridSize + vec2(sizeOffset * 0.35, sizeOffset * 0.1) * vec2(intensity)); // Apply the offset to the domain
	st -= 0.5; // -0.5-> 0.5
	st *= 2.0; // -1.0-> 1.0

	// Draw a circle
	vec2 p = st / gridSize;
	float mainDropDist = smoothstep(0.03, 0.02, length(p));

	return (p * mainDropDist * 2.5);
}

void main()
{
	// 3 layers of drops
	vec2 drops = GetDrops(TexCoord0, pts + 21.5, 0.75);
	drops += GetDrops(TexCoord0 * 2.0, pts + 251.5, 1.75) * 0.5;
	drops += GetDrops(TexCoord0 * 4.0, pts + 32.5, 2.0) * 0.25;

	gl_FragColor = texture2D(tex, TexCoord0 + drops);
}
